CREATE DATABASE IF NOT EXISTS korfezo1_siparis CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE korfezo1_siparis;

CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  username VARCHAR(50) UNIQUE,
  password VARCHAR(255) NOT NULL,
  role ENUM('admin','user') DEFAULT 'admin',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS musteriler (
  id INT AUTO_INCREMENT PRIMARY KEY,
  firma_adi VARCHAR(100),
  ad VARCHAR(50),
  soyad VARCHAR(50),
  telefon VARCHAR(30),
  adres TEXT
);

CREATE TABLE IF NOT EXISTS urunler (
  id INT AUTO_INCREMENT PRIMARY KEY,
  urun_kodu VARCHAR(50),
  urun_adi VARCHAR(200),
  adet INT DEFAULT 0,
  fiyat DECIMAL(10,2) DEFAULT 0,
  toptanci VARCHAR(100),
  teslim_durumu ENUM('Bekliyor','Teslim Edildi') DEFAULT 'Bekliyor'
);

CREATE TABLE IF NOT EXISTS siparisler (
  id INT AUTO_INCREMENT PRIMARY KEY,
  musteri_id INT,
  siparis_tarihi TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  odeme_durumu ENUM('Bekliyor','Ödendi') DEFAULT 'Bekliyor',
  teslim_durumu ENUM('Bekliyor','Teslim Edildi') DEFAULT 'Bekliyor',
  FOREIGN KEY (musteri_id) REFERENCES musteriler(id) ON DELETE SET NULL
);

CREATE TABLE IF NOT EXISTS siparis_detay (
  id INT AUTO_INCREMENT PRIMARY KEY,
  siparis_id INT,
  urun_id INT,
  adet INT,
  fiyat DECIMAL(10,2),
  toplam DECIMAL(10,2),
  FOREIGN KEY (siparis_id) REFERENCES siparisler(id) ON DELETE CASCADE,
  FOREIGN KEY (urun_id) REFERENCES urunler(id) ON DELETE SET NULL
);

INSERT INTO users (username,password,role) VALUES ('admin','$2y$10$CXmrMvt.sSTQnyupIrdlkOp6kX9zjmCeYVENGCVhrnb0FBOQynYya','admin');
INSERT INTO musteriler (firma_adi,ad,soyad,telefon,adres) VALUES ('ABC Otomotiv','Ali','Yılmaz','05550000000','İstanbul');
INSERT INTO urunler (urun_kodu,urun_adi,adet,fiyat,toptanci) VALUES ('U001','Fren Diski',100,250.00,'Toptancı A'),('U002','Filtre',200,50.00,'Toptancı B');
