<?php
session_start();
require_once 'includes/db.php';
require_once 'includes/functions.php';

$error = "";

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    if(login($pdo, $_POST['username'], $_POST['password'])) {
        header("Location: /siparis_takip/index.php");
        exit;
    } else {
        $error = "Kullanıcı adı veya şifre hatalı!";
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
<meta charset="UTF-8">
<title>Giriş</title>
<link rel="stylesheet" href="/siparis_takip/assets/bootstrap.min.css">
</head>
<body class="bg-light">
<div class="container mt-5" style="max-width:400px;">
<div class="card p-4">
<h4 class="text-center mb-3">Sipariş Takip Giriş</h4>

<?php if($error): ?>
    <div class="alert alert-danger"><?=$error?></div>
<?php endif; ?>

<form method="POST">
    <div class="mb-3">
        <label>Kullanıcı Adı</label>
        <input type="text" name="username" class="form-control" required>
    </div>

    <div class="mb-3">
        <label>Şifre</label>
        <input type="password" name="password" class="form-control" required>
    </div>

    <button class="btn btn-primary w-100">Giriş Yap</button>
</form>

</div>
</div>
</body>
</html>